<?php
/* --------------------------------------------------------------
  ProductOptionVpe.php 2021-11-03
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2021 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Deprecated\Vpe\App\Actions;

use Gambio\Admin\Modules\Deprecated\Vpe\App\Data\VpeRepository;
use Gambio\Core\Application\Http\AbstractAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * Class ProductOptionVpe
 * @package    Gambio\Admin\Modules\Deprecated\Vpe\App\Actions
 * @deprecated will be removed with the release of 4.7!
 */
class ProductOptionVpe extends AbstractAction
{
    /**
     * @var VpeRepository
     */
    private $repository;
    
    
    /**
     * @param VpeRepository $repository
     */
    public function __construct(VpeRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $productId        = (int)$request->getAttribute('productId');
        $productOptionVpe = $this->repository->productVpeData($productId);
        $data             = array_map(function ($element) {
            return [
                'productOptionId' => $element['product_option_id'],
                'vpeId'           => $element['vpe_id'],
                'vpeValue'        => $element['vpe_value'],
            ];
        }, $productOptionVpe);
        
        return $response->withJson(['data' => $data]);
    }
}